$(function() {
    // 相互参照の埋め込みSIコンテンツの開く/閉じる
    $('a.xref-iframe').bind("click", function () {
        iframeId = $(this).attr("href").replace(/#/g, "if-");
        $("#" + iframeId).animate({ height: 'toggle' }, 'slow');
        return false;
    });

    // 埋め込みSIコンテンツはデフォルトでオープン
    //// 埋め込みSIコンテンツを隠す
    //$('.inc_container').each(function(){
    //		$(this).hide();
    //});

    var currentTestblocks = null;
    var currentSsiDiag = null;

    $( ".resizable" ).resizable({
        handles: " n, s"
    });

    var checkTestBlockFlow = function(id) {
        $.each($("#"+id).parents("div.diagchart").find('div.ques-flow'),function() {
            if(this.id == id) {
                $(this).addClass("active");
            } else {
                $(this).removeClass("active");
            }
        });
    }

    var activeToConfirmed = function(id) {
        $.each($("#"+id).parents("div.diagchart").find('.active'),function() {
            $(this).removeClass("active");
            $(this).addClass("confirmed");
        });
    }

    var hideCaution = function(object) {
        var parent = $(object).closest("div.ssi-diag");
        if (parent[0]) {
            parent.find('div.testblock').each(function () {
                parent.find('.diagtest .diagattn .caution-label').css("display", "none");
                parent.find('.diagtest .diagattn .caution').css("display", "none");
                parent.find('.diagtest .diagattn .note-label').css("display", "none");
                parent.find('.diagtest .diagattn .note').css("display", "none");
            });
        }
        else {
            $('.diagtest .diagattn .caution-label').css("display", "none");
            $('.diagtest .diagattn .caution').css("display", "none");
            $('.diagtest .diagattn .note-label').css("display", "none");
            $('.diagtest .diagattn .note').css("display", "none");
        }
    }

    var showTestBlock = function (id) {
        if (id == "#") {
            // end表示
            var cname = "testblock-end";
            if (currentTestblocks != null) {
                currentTestblocks.find("." + cname).slideDown();
            } else {
                if (currentSsiDiag != null) {
                    currentSsiDiag.find("." + cname).slideDown();
                } else {
                    $("#" + cname).slideDown();
                }
            }
        } else {
            $(id).slideDown();
        }

        if ($.isArray(myLayout)) {
            jQuery.each(myLayout, function () {
                this.resizeAll();
            });
        } else if (myLayout) {
            myLayout.resizeAll();
            $(window).resize();
        }
    }

    $('div.ques-flow').bind("click", function() {
        hideTestBlock(this);
        activeToConfirmed(this.id);
        hideCaution(this);
        //$("#"+$(this).data("testblock-id")).show();
        checkTestBlockFlow(this.id);
        testblockid = this.id.replace("flow-", "");
        $('#start-' + testblockid).hide();
        showTestBlock("#" + testblockid);
    });

    $('div.startButton').bind("click", function() {
        var testblockid = this.id.replace('start-', '');
        var flow = 'flow-' + testblockid;
        activeToConfirmed(flow);
        hideCaution(this);
        checkTestBlockFlow(flow);
        $('#' + this.id).hide();
        showTestBlock('#' + testblockid);
    });

    var hideTestBlock = function(object) {
        var url = window.location;
        var path = url.href.split('/');
        var print = $.inArray("print", path);
        if (print != -1) {
            return;
        }

        if (typeof object === "undefined") {
            $('.diagsection div.testblock').each(function () {
                $(this).hide();
            });
        } else {
            var parent = $(object).closest("div.ssi-diag");
            if (parent.size() == 0) {
                currentTestblocks = null;
                $('div.testblock').each(function () {
                    $(this).hide();
                });
            } else {
                sitopic_id = $(object).closest("div.sitopic-testblocks").data("id");

                if (sitopic_id == null) {
                    sitopic_id = $(object).closest("div.flowchart").attr("id");
                }
                if (typeof sitopic_id === "undefined") {
                    $(parent).find('div.testblock').each(function () {
                        $(this).hide();
                    });
                } else {
                    parent.find("div.sitopic-testblocks").each(function () {
                        if ($(this).data("id") == sitopic_id) {
                            currentTestblocks = $(this);
                            $(this).find('div.testblock').each(function () {
                                $(this).hide();
                            });
                        }
                    });
                }
            }
        }
    }
    hideTestBlock();
    $("div.sitopic-testblocks").each(function (i) {
        if (i > 0) $(this).hide();
    });

    // TESTBLOCKのansリンク押下時のアクション
    $('.ans a.xref').bind("click", function() {
        if ($(this).closest('.diagsection').length > 0) {
            thisTestblockId = $(this).parents(".testblock").attr("id");
            $("#flow-"+thisTestblockId).addClass("confirmed");
            if($(this).hasClass('xref-testblock')) {
                nextTestblockId = $(this).attr("href");
                nextFlowId = nextTestblockId.replace(/#/g, "flow-");
                checkTestBlockFlow(nextFlowId);
                hideTestBlock(this);
                // スクロール
                diagbox = $(this).closest("div.ssi-diag").find('.diagflow');
                diagbox.scrollTo("#" + nextFlowId, 'normal', { offset: { top: -100, left: 0 } });
                showTestBlock(nextTestblockId);
                return false;
            }
        } else {
            var href = $(this).attr('href');
            if (href.lastIndexOf('#', 0) === 0) {
                $.scrollTo(href, { duration:300 });
                return false;
            }
            else {
                return true;
            }
        }
    });

    // TESTBLOCKのansリンクアイコン押下時のアクション
    $('.ans a.xref-icon-link').bind("click", function() {
        if ($(this).closest('.diagsection').length > 0) {
            thisTestblockId = $(this).parents(".testblock").attr("id");
            $("#flow-"+thisTestblockId).addClass("confirmed");
            //if($(this).hasClass('xref-testblock')) {
                nextTestblockId = $(this).attr("href");
                nextFlowId = nextTestblockId.replace(/#/g, "flow-");
                checkTestBlockFlow(nextFlowId);
                hideTestBlock(this);
                // スクロール
                diagbox = $(this).closest("div.ssi-diag").find('.diagflow');
                diagbox.scrollTo("#" + nextFlowId, 'normal', { offset: { top: -100, left: 0 } });
                showTestBlock(nextTestblockId);
                return false;
            //}
        } else {
            var href = $(this).attr('href');
            if (href.lastIndexOf('#', 0) === 0) {
                $.scrollTo(href, { duration:300 });
                return false;
            }
            else {
                return true;
            }
        }
    });

    // Flowのansリンク押下時のアクション
    $('.ans-to a.xref').bind("click", function() {
        //thisTestblockId = $(this).parents(".testblock").attr("id");
        thisflowid = $(this).parents(".tb-flow").find(".ques-flow").attr("id");
        $("#"+thisflowid).addClass("confirmed");
        if($(this).hasClass('xref-testblock')) {
            $(this).parent().parent().addClass("confirmed");
            nextTestblockId = $(this).attr("href");
            nextFlowId = nextTestblockId.replace(/#/g, "flow-");
            checkTestBlockFlow(nextFlowId);
            hideTestBlock(this);
            // スクロール
            diagbox = $(this).closest("div.ssi-diag").find('.diagflow');
            diagbox.scrollTo("#" + nextFlowId, 'normal', { offset: { top: -100, left: 0 } });
            showTestBlock(nextTestblockId);
            return false;
        }
    });

    // Flowのansリンクアイコン押下時のアクション
    $('.ans-to a.xref-icon-link').bind("click", function() {
        //thisTestblockId = $(this).parents(".testblock").attr("id");
        thisflowid = $(this).parents(".tb-flow").find(".ques-flow").attr("id");
        $("#"+thisflowid).addClass("confirmed");
        //if($(this).hasClass('xref-testblock')) {
            $(this).parent().parent().addClass("confirmed");
            nextTestblockId = $(this).attr("href");
            nextFlowId = nextTestblockId.replace(/#/g, "flow-");
            checkTestBlockFlow(nextFlowId);
            hideTestBlock(this);
            // スクロール
            diagbox = $(this).closest("div.ssi-diag").find('.diagflow');
            diagbox.scrollTo("#" + nextFlowId, 'normal', { offset: { top: -100, left: 0 } });
            showTestBlock(nextTestblockId);
            return false;
        //}
    });

    // TESTBLOCKのans押下時のアクション
    $('.ans .testblock-ans').bind("click", function() {
        thisTestblockId = $(this).parents(".testblock").attr("id");
        $("#flow-"+thisTestblockId).addClass("confirmed");
        if($(this).data("target") != undefined) {
            nextTestblockId = $(this).data("target");
            nextFlowId = nextTestblockId.replace(/^/g, "flow-");
            if (nextFlowId.length > 5) {
	            $("#flow-"+this.id).addClass("active");
	            activeToConfirmed(this.id);
            	checkTestBlockFlow(nextFlowId);
            }
            hideTestBlock(this);
            if (nextTestblockId == "") {
            	var yesno = $(this).parent().parent().attr("class");
            	var t = $("#" + thisTestblockId + " ." + yesno + "-content");
            	if (t.length > 0) {
            		$(".testblockendlabel")[0].innerHTML = t[0].outerHTML;
            	}
            }
           	showTestBlock("#" + nextTestblockId);

            // スクロール
            diagbox = $(this).closest("div.ssi-diag").find('.diagflow');
            diagbox.scrollTo("#" + nextFlowId, 'normal', { offset: { top: -100, left: 0 } });
            return false;
        } else {
            activeToConfirmed(this.id);
            $("#flow-"+this.id).addClass("active");
            $("#flow-"+thisTestblockId).removeClass("active");
        }
    });

    $(".ans .yes-title > div").bind("click", function() {
        if (!$(this).hasClass("testblock-ans")) {
            var anchors = $(this).closest('.ans').find('.yes-content a');
            if (anchors.length >= 1) {
                anchors[0].click();
                return false;
            }
        }
        return true;
    });
    $(".ans .no-title > div").bind("click", function() {
        if (!$(this).hasClass("testblock-ans")) {
            var anchors = $(this).closest('.ans').find('.no-content a');
            if (anchors.length >= 1) {
                anchors[0].click();
                return false;
            }
        }
        return true;
    });
    $(".ans .choice-title > div").bind("click", function () {
        if (!$(this).hasClass("testblock-ans")) {
            var anchors = $(this).closest('.choice-title').next('.choice-content').find('a');
            if (anchors.length >= 1) {
                anchors[0].click();
                return false;
            }
        }
        return true;
    });

    // 診断ブロックをリサイズ可能に
    $(".diagchart").resizable({
        handles: "s"
    });

    $( ".dialog" ).dialog({
        autoOpen: false

    });

    $("#opener").click(function () {
        // 無効になっているときは何もしない
        if ($(this).hasClass("ui-state-disabled")) {
            return;
        }

        current_chart_id = $("select.diagsection-select").val();
        if (current_chart_id != null) {
            ssi_id = get_ssi_id(current_chart_id);
            if ($("#diag-" + ssi_id).size() > 0) {
                $("#diag-" + ssi_id).dialog().dialog("open");
            } else {
                $(".dialog").dialog().dialog("open");
            }
        } else {
            $(".dialog").dialog().dialog("open");
        }
    });

    // diaggd用処理
    $(".gd-dialog").not(".show-only").hide();
    $("#gd-opener").click(function () {
        if ($("#gddiag").size() > 0) {
            var url = "../../index.html?id=" + $(this).closest(".si").attr("id") + "#show-only=gddiag";
            if ($(document.body).data("mode") == "preview") {
                url = "#show-only=gddiag";
            }
            window.open(url);
        }
    });

    $(".ca-dialog").dialog({
        autoOpen: false
    });
    $("#ca-opener").click(function () {
        // 無効になっているときは何もしない
        if ($(this).hasClass("ui-state-disabled")) {
            return;
        }

        current_chart_id = $("select.diagsection-select").val();
        if (current_chart_id != null) {
            ssi_id = get_ssi_id(current_chart_id);
            if ($("#cadiag-" + ssi_id).size() > 0) {
                $("#cadiag-" + ssi_id).dialog("open");
            } else {
                $(".ca-dialog").dialog().dialog("open");
            }
        } else {
            $(".ca-dialog").dialog().dialog("open");
        }
    });

    get_ssi_id = function (id) {
        if (id.length > 12) {
            ssi_id = id.substring(0, 12);
        } else {
            ssi_id = id;
        }
        return ssi_id;
    }
    // 先頭要素以外は隠す
    $(".ssi-diag").each(function (j) {
        $(this).find(".diagsubchart").each(function (i) {
            if (i > 0) {
                $(this).hide();
            }
        });
        // 先頭要素以外は隠す
        $(this).find(".diagsubwi").each(function (i) {
            if (i > 0) {
                $(this).hide();
            }
        });
    });

    // 先頭要素以外は隠す（SSI選択対応）
    $(".si").each(function (j) {
        $(this).find(".ssi.ssiselector").each(function (i) {
            if (i > 0) {
                $(this).hide();
            }
            else {
                setCurrentSSI($(this).attr("id"));
            }
        });
    });

    // 配線図セクション対応スクリプト
    $("#ssi-selector-button").click(function () {
        var ssiId = $("#ssi-selector-select").val();
        if ($("#" + ssiId).size() > 0) {
            $.scrollTo("#" + ssiId, 500);
        }
    });

    $("a.wi-link-scroll").bind("click", function () {
        if ($.find($(this).attr("xlink:href")).length > 0) {
            $.scrollTo($($(this).attr("xlink:href")), 500);
        }
        return false;
    });

    // 複数配線図の表示切替
    $("select.diagwi-select").bind("change", function () {
        var val = $(this).val();
        var parent = $(this).closest("div.ssi-diag");
        if (parent.size() > 0) {
            parent.find(".diagsubwi").each(function (i) {
                if ($(this).attr("id") != "diag-" + val) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
        } else {
            $(".diagsubwi").each(function (i) {
                if ($(this).attr("id") != "diag-" + val) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
        }
    });

    // SSIブロックの表示（フェードイン）
    showSsiBlock = function (val) {
        $(".ssi-diag").each(function (i) {
            if ($(this).attr("id") == val) {
                currentSsiDiag = $(this);
                $(this).fadeIn();
            }
        });
    }

    // 診断セクションの複数SSIの表示切替
    $("select.diagsection-select").bind("change", function () {
        // まず表示中のダイアログを閉じる
        $(".ca-dialog,.dialog").each(function () {
            $(this).dialog("close");
        });

        var visible_ssi = $(".ssi-diag:visible").attr("id");
        var val = $(this).val();
        $("#" + visible_ssi).fadeOut(250, function () {
            showSsiBlock(val);

            // CAUTIONボタンの表示切替
            ssi_id = get_ssi_id(val);
            if ($("#cadiag-" + ssi_id).size() > 0) {
                if ($("#cadiag-" + ssi_id).text().trim() != '') {
                    $("#ca-opener").removeClass("ui-state-disabled");
                }
                else {
                    $("#ca-opener").addClass("ui-state-disabled");
                }

                $("#ca-opener").show();
            } else {
                $("#ca-opener").hide();
            }

            // NOTEボタンの表示切替
            if ($("#diag-" + ssi_id).size() > 0) {
                if ($("#diag-" + ssi_id).text().trim() != '') {
                    $("#opener").removeClass("ui-state-disabled");
                }
                else {
                    $("#opener").addClass("ui-state-disabled");
                }

                $("#opener").show();
            } else {
                $("#opener").hide();
            }
        });
    });

    // 複数SSIの表示切替
    $("select.ssiselector").bind("change", function () {
        var visible_ssi = $(".ssi.ssiselector:visible").attr("id");
        var val = $(this).val();
        $("#" + visible_ssi).fadeOut(250, function () {
            setCurrentSSI(val);

            $("#" + val).fadeIn(250);
        });
    });

    // 複数SSIの切り替えがある場合に実行するコード
    if ($("select.diagsection-select")[0]) {
        if (location.hash.length > 1) {
            var ssiid = location.hash.substr(1);
            var selectid = "";

            $("select.diagsection-select > option").each(function () {
                if ($(this).val().indexOf(ssiid) >= 0) {
                    selectid = $(this).val();
                    return false;
                }
            });

            if (selectid != "") {
                $("select.diagsection-select").val(selectid);
            }
        }

        // changeイベントを発生させて初期化する
        $("select.diagsection-select").change();
    }
})

function goTable(id) {
    window.open(id + ".html", "table");
}

function closeCaDialog() {
	$('.ca-dialog').dialog('close');
}

var openWin;
function openTextLinkDLG(filename) {
	closeCaDialog();
	if (openWin && !(openWin.closed)) {
		openWin.close();
	}
	openWin = window.open(filename);
}

// 高機能配線図リンク先ダイアログ表示
function setTextLinkDLG(ssid, titletext) {
    var ssids = ssid.split(',');
    var titletexts = titletext.split('^');

    if (ssids.length > 1) {
        var element = document.getElementsByClassName("ca-dialog-ptext");
        if (element != null) {
            for (var i = 0; i < element.length; i++) {
                if (element[i] != null) {
                    element[i].innerHTML = "";
                    for (var s = 0; s < ssids.length; s++) {
                        if (element[i].innerHTML != "") {
                            element[i].innerHTML = element[i].innerHTML + "<br/>";
                        }
                        var codes = titletexts[s].split('#');
                        var url = "";
                        var filename = "../../index.html?id=" + ssids[s].substring(0, 10) + "#" + ssids[s];
                        if (codes.length > 1) {
                            var code = codes[1].replace(/;/g, ",");
                            filename = filename + "&code=" + code;
                        }
                        url = "openTextLinkDLG(\"" + filename + "\");";
                        element[i].innerHTML = element[i].innerHTML + "<a class='textlink' title='" + codes[0] + "' href='javascript:void(0)' onclick='" + url + "' ><img class=\"xref-icon\" src=\"../image/btn_link.gif\" />" + codes[0] + "</a>";
                    }
                    break;
                }
            }
            var elm_diag = element[0].parentNode.parentNode.parentNode.parentNode.parentNode;
            var att = elm_diag.getAttribute("id");
            if (att != null) {
                $("#" + att).dialog().dialog("open");
            }
            else {
                $('.ca-dialog').dialog().dialog('open');
            }
        }
    }
    else {
        var codes = titletexts[0].split('#');
        var code = null;
        var filename = "../../index.html?id=" + ssids[0].substring(0, 10) + "#" + ssids[0];
        if (codes.length > 1) {
            code = codes[1].replace(/;/g, ",");
            filename = filename + "&code=" + code;
        }
        openTextLinkDLG(filename);
    }
}


// 高機能配線図リンク先CODEをURLパラメータから取得
function getCodeByParameter() {
    var a = decodeURIComponent(location);
    var q = a.split('?');
    if (q != '') {
    	var b = null;
	   	if (q.length > 1) {
	    	b = q[1].split('&');
		}
		else {
	    	b = q[0].split('&');
		}
        for (var i = 0; i < b.length; i++) {
            var c = b[i].split('=');
            if (c != '' && c[0] == 'code') {
                return c[1].toUpperCase();
            }
        }
    }

    return "";
}

// 高機能配線図リンク先IDの#コードをURLパラメータから取得
function getIdByParameter() {
    var a = decodeURIComponent(location);
    var q = a.split('#');
    if (q != '') {
    	if (q.length > 1) {
	    	var b = q[1].split('&');
	        return b[0];
        }
    }

    return "";
}

// 高機能配線図リンク先のテキストをハイライト
function setHighlight() {
  // for highlight function on the wiring section
  var paramId = getIdByParameter();
  var paramCode = getCodeByParameter();
  if (paramCode != null) {
    var codes = paramCode.split(',');
    if (codes[0]=="") {
      return;
    }
    var textval = null;
    for (var c=0; c  < codes.length; c++) {
      var text = null;
      if (paramId) {
          var texts = $("#" + paramId + " [id^=" + codes[c] + "]");
      	if (texts.size() > 0) {
      		text = texts[0];
      	}
      	else {
      	    var lhashs = paramId.split('-');
      	    var text2s = $("#" + lhashs[0] + " [id^=" + codes[c] + "]");
      	    if (text2s.size() > 0) {
      	        // もし同じIDのものが複数あるならば対象を絞って検索
      	        if (text2s.size() > 1) {
      	            var selector = "div[id='" + lhashs[0] + "']";
      	            if (lhashs.length > 1) {
      	                selector += " [ear='" + lhashs[1] + "']";
      	            }
      	            selector += " [id^=" + codes[c] + "]";
      	            if ($(selector).size() > 0) {
      	                text = $(selector)[0];
      	            }
      	            else {
      	                text = text2s[0];
      	            }
      	        }
      	        else {
      	            text = text2s[0];
      	        }
      	    }
      		else {
      			text = document.getElementById(codes[c]);
      		}
      	}
      }
      else {
      	text = document.getElementById(codes[c]);
      }

      if (text != null) {
      	var childs = text.childNodes;
     	textval = childs[0].nodeValue;

        var att = text.getAttribute("transform");
        var bbox = text.getBBox();

        var rect = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        rect.setAttribute('transform', att);

        rect.x.baseVal.value = bbox.x;
        rect.y.baseVal.value = bbox.y;
        rect.width.baseVal.value = bbox.width;
        rect.height.baseVal.value = bbox.height;

        rect.setAttribute("class","highlight");
        text.parentNode.insertBefore(rect, text);
      }
    }

    // 他の箇所もハイライト設定
    if (textval != null) {
    	var textelms = document.getElementsByTagName("text");
    	for (var t=0; t < textelms.length; t++) {
    		var tatt = textelms[t].getAttribute("id");
    		if (tatt != null) {
    		if (tatt.substring(0,2) == codes[0].substring(0,2)) {
		      	var childs = textelms[t].childNodes;
		     	if (childs[0].nodeValue == textval) {
		     		if (textelms[t].previousElementSibling == null || textelms[t].previousElementSibling.getAttribute("class") != "highlight") {
		     			var att = textelms[t].getAttribute("transform");
				        var bbox = textelms[t].getBBox();

				        var rect = document.createElementNS("http://www.w3.org/2000/svg", "rect");
				        rect.setAttribute('transform', att);

				        rect.x.baseVal.value = bbox.x;
				        rect.y.baseVal.value = bbox.y;
				        rect.width.baseVal.value = bbox.width;
				        rect.height.baseVal.value = bbox.height;

				        rect.setAttribute("class","highlight");
				        textelms[t].parentNode.insertBefore(rect, textelms[t]);
		     		}
		     	}
    		}
    		}
    	}
    }
  }
}
